/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.util.FurnitureUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MirrorBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<FurnitureUtil.VerticalConnectingType> TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final Map<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>> SHAPES_SUPPLIERS = new HashMap<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>>();
    private static final Map<Direction, Map<FurnitureUtil.VerticalConnectingType, VoxelShape>> SHAPES = new EnumMap<Direction, Map<FurnitureUtil.VerticalConnectingType, VoxelShape>>(Direction.class);

    public MirrorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
        Level world = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        blockState = (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.above()), world.getBlockState(clickedPos.below()))));
        return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(clickedPos).getType() == Fluids.WATER));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.getBlockState(pos.above()), world.getBlockState(pos.below()));
        if (state.getValue(TYPE) != type) {
            state = (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
        }
        world.setBlock(pos, state, 3);
    }

    public FurnitureUtil.VerticalConnectingType getType(BlockState state, BlockState above, BlockState below) {
        boolean shapeBelowSame;
        boolean shapeAboveSame = above.getBlock() == state.getBlock() && above.getValue((Property)FACING) == state.getValue((Property)FACING);
        boolean bl = shapeBelowSame = below.getBlock() == state.getBlock() && below.getValue((Property)FACING) == state.getValue((Property)FACING);
        if (shapeAboveSame && shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        if (shapeAboveSame) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (shapeBelowSame) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.getValue(TYPE));
        return SHAPES.get(direction).get((Object)type);
    }

    private static VoxelShape makeTopShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.8125, (double)0.875, (double)0.9375, (double)0.9375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.875, (double)0.9375, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.9375, (double)0.8125, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.875, (double)0.9375, (double)0.1875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)0.875, (double)0.1875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.1875, (double)0.875, (double)0.9375, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.1875, (double)0.9375, (double)0.8125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.875, (double)0.9375, (double)0.1875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.8125, (double)0.875, (double)0.9375, (double)0.9375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.1875, (double)0.875, (double)0.9375, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.1875, (double)0.9375, (double)0.8125, (double)0.8125, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.875, (double)0.1875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.875, (double)0.9375, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.9375, (double)0.8125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    static {
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.NONE, MirrorBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.MIDDLE, MirrorBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.TOP, MirrorBlock::makeTopShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.VerticalConnectingType.BOTTOM, MirrorBlock::makeBottomShape);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            SHAPES.put(direction, new HashMap());
            for (Map.Entry<FurnitureUtil.VerticalConnectingType, Supplier<VoxelShape>> entry : SHAPES_SUPPLIERS.entrySet()) {
                SHAPES.get(direction).put(entry.getKey(), FurnitureUtil.rotateShape(Direction.NORTH, direction, entry.getValue().get()));
            }
        }
    }
}

