/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.explosiveenhancement.registry;

import dev.xylonity.explosiveenhancement.particle.custom.BlastWaveParticle;
import dev.xylonity.explosiveenhancement.particle.custom.BubbleParticle;
import dev.xylonity.explosiveenhancement.particle.custom.FireballParticle;
import dev.xylonity.explosiveenhancement.particle.custom.ShockwaveParticle;
import dev.xylonity.explosiveenhancement.particle.custom.SmokeParticle;
import dev.xylonity.explosiveenhancement.particle.custom.SparksParticle;
import dev.xylonity.explosiveenhancement.particle.custom.UnderwaterBlastwaveParticle;
import dev.xylonity.explosiveenhancement.particle.custom.UnderwaterSparksParticle;
import dev.xylonity.explosiveenhancement.registry.ExplosiveParticleManager;
import dev.xylonity.explosiveenhancement.registry.IExplosiveParticleHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ExplosiveParticles {
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> BLASTWAVE = ExplosiveParticles.register("blastwave");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> FIREBALL = ExplosiveParticles.register("fireball");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> BLANK_FIREBALL = ExplosiveParticles.register("blank_fireball");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> SMOKE = ExplosiveParticles.register("smoke");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> SPARKS = ExplosiveParticles.register("sparks");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> BUBBLE = ExplosiveParticles.register("bubble");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> SHOCKWAVE = ExplosiveParticles.register("shockwave");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> BLANK_SHOCKWAVE = ExplosiveParticles.register("blank_shockwave");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> UNDERWATERBLASTWAVE = ExplosiveParticles.register("underwaterblastwave");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> UNDERWATERSPARKS = ExplosiveParticles.register("underwatersparks");

    public static void init() {
    }

    public static void registerProviders(RegisterParticleProvidersEvent event) {
        IExplosiveParticleHandler manager = (IExplosiveParticleHandler)Minecraft.getInstance().particleEngine;
        manager.registerMutableSprite(BLASTWAVE, BlastWaveParticle.Provider::new);
        manager.registerMutableSprite(FIREBALL, FireballParticle.Provider::new);
        manager.registerMutableSprite(BLANK_FIREBALL, FireballParticle.Provider::new);
        manager.registerMutableSprite(SMOKE, SmokeParticle.Provider::new);
        manager.registerMutableSprite(SPARKS, SparksParticle.Provider::new);
        manager.registerMutableSprite(BUBBLE, BubbleParticle.Provider::new);
        manager.registerMutableSprite(SHOCKWAVE, ShockwaveParticle.Provider::new);
        manager.registerMutableSprite(BLANK_SHOCKWAVE, ShockwaveParticle.Provider::new);
        manager.registerMutableSprite(UNDERWATERBLASTWAVE, UnderwaterBlastwaveParticle.Provider::new);
        manager.registerMutableSprite(UNDERWATERSPARKS, UnderwaterSparksParticle.Provider::new);
    }

    private static DeferredHolder<ParticleType<?>, SimpleParticleType> register(String name) {
        return ExplosiveParticleManager.PARTICLE_REGISTER.register(name, () -> new SimpleParticleType(false));
    }
}

