/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.ceremony;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.music.MusicInstrument;

public final class Ceremony {
    private final int musicNeeded;
    private final int maxStartupTime;
    private final Supplier<CeremonyInstance> factory;
    private final List<MusicInstrument> selectors;
    @Nullable
    private String descriptionId;

    public Ceremony(int musicNeeded, int maxStartupTime, Supplier<CeremonyInstance> factory, MusicInstrument selector1, MusicInstrument selector2) {
        this.musicNeeded = musicNeeded;
        this.maxStartupTime = maxStartupTime;
        this.factory = factory;
        this.selectors = List.of(selector1, selector2);
    }

    public Ceremony(int musicNeeded, int maxStartupTime, Supplier<CeremonyInstance> factory, Supplier<MusicInstrument> selector1, Supplier<MusicInstrument> selector2) {
        this(musicNeeded, maxStartupTime, factory, selector1.get(), selector2.get());
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId((String)"totemic.ceremony", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionId;
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public final ResourceLocation getRegistryName() {
        return TotemicAPI.get().registry().ceremonies().getKey((Object)this);
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    public int getMusicNeeded() {
        return this.musicNeeded;
    }

    public int getMaxStartupTime() {
        return this.maxStartupTime;
    }

    public int getAdjustedMaxStartupTime(Difficulty diff) {
        return switch (diff) {
            default -> throw new MatchException(null, null);
            case Difficulty.PEACEFUL, Difficulty.EASY -> (int)(1.1f * (float)this.getMaxStartupTime());
            case Difficulty.NORMAL -> this.getMaxStartupTime();
            case Difficulty.HARD -> (int)(0.875f * (float)this.getMaxStartupTime());
        };
    }

    public CeremonyInstance createInstance() {
        return this.factory.get();
    }

    public final List<MusicInstrument> getSelectors() {
        return this.selectors;
    }
}

