/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.music;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import pokefenn.totemic.api.TotemicAPI;

public final class MusicInstrument {
    private final int baseOutput;
    private final int musicMaximum;
    private ItemStack itemStack = ItemStack.EMPTY;
    @Nullable
    private Supplier<SoundEvent> sound;
    @Nullable
    private String descriptionId;

    public MusicInstrument(int baseOutput, int musicMaximum) {
        this.baseOutput = baseOutput;
        this.musicMaximum = musicMaximum;
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    @Nullable
    public Supplier<SoundEvent> getSound() {
        return this.sound;
    }

    public MusicInstrument setItem(ItemStack itemStack) {
        this.itemStack = Objects.requireNonNull(itemStack);
        return this;
    }

    public MusicInstrument setItem(ItemLike item) {
        return this.setItem(new ItemStack(item));
    }

    public MusicInstrument setSound(@Nullable Supplier<SoundEvent> sound) {
        this.sound = sound;
        return this;
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId((String)"totemic.instrument", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionId;
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public final ResourceLocation getRegistryName() {
        return TotemicAPI.get().registry().instruments().getKey((Object)this);
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    public int getBaseOutput() {
        return this.baseOutput;
    }

    public int getMusicMaximum() {
        return this.musicMaximum;
    }
}

