/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.totem;

import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.registry.RegistryAPI;
import pokefenn.totemic.api.totem.PortableTotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;

public sealed class TotemCarving
permits PortableTotemCarving {
    public static final Codec<TotemCarving> CODEC = TotemicAPI.get().registry().totemCarvings().byNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, TotemCarving> STREAM_CODEC = ByteBufCodecs.registry(RegistryAPI.TOTEM_CARVING_REGISTRY);
    private final List<TotemEffect> effects;
    @Nullable
    private String descriptionId;

    public TotemCarving(TotemEffect effect) {
        this.effects = List.of(effect);
    }

    public TotemCarving(TotemEffect ... effects) {
        this.effects = List.of(effects);
    }

    public TotemCarving(List<? extends TotemEffect> effects) {
        this.effects = List.copyOf(effects);
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId((String)"totemic.totem", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionId;
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public final ResourceLocation getRegistryName() {
        return TotemicAPI.get().registry().totemCarvings().getKey((Object)this);
    }

    public List<TotemEffect> getEffects() {
        return this.effects;
    }

    public String toString() {
        return this.getRegistryName().toString();
    }
}

