/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.apiimpl.ceremony;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import pokefenn.totemic.api.ceremony.CeremonyAPI;
import pokefenn.totemic.util.BlockUtil;

public enum CeremonyAPIImpl implements CeremonyAPI
{
    INSTANCE;


    @Override
    public void forEachBlockIn(Level level, BoundingBox box, BiConsumer<BlockPos, BlockState> action) {
        level.getProfiler().incrementCounter("totemic.forEachBlockIn");
        SectionPos startSec = SectionPos.of((BlockPos)BlockUtil.lowerCorner(box));
        SectionPos endSec = SectionPos.of((BlockPos)BlockUtil.upperCorner(box));
        for (int chunkX = startSec.getX(); chunkX <= endSec.getX(); ++chunkX) {
            for (int chunkZ = startSec.getZ(); chunkZ <= endSec.getZ(); ++chunkZ) {
                if (!level.hasChunk(chunkX, chunkZ)) continue;
                LevelChunk chunk = level.getChunk(chunkX, chunkZ);
                for (int secY = startSec.getY(); secY <= endSec.getY(); ++secY) {
                    LevelChunkSection section;
                    if (secY < chunk.getMinSection() || secY >= chunk.getMaxSection() || (section = chunk.getSection(chunk.getSectionIndexFromSectionY(secY))).hasOnlyAir()) continue;
                    SectionPos secPos = SectionPos.of((int)chunkX, (int)secY, (int)chunkZ);
                    int secMinX = box.minX() <= secPos.minBlockX() ? 0 : SectionPos.sectionRelative((int)box.minX());
                    int secMinY = box.minY() <= secPos.minBlockY() ? 0 : SectionPos.sectionRelative((int)box.minY());
                    int secMinZ = box.minZ() <= secPos.minBlockZ() ? 0 : SectionPos.sectionRelative((int)box.minZ());
                    int secMaxX = box.maxX() >= secPos.maxBlockX() ? 15 : SectionPos.sectionRelative((int)box.maxX());
                    int secMaxY = box.maxY() >= secPos.maxBlockY() ? 15 : SectionPos.sectionRelative((int)box.maxY());
                    int secMaxZ = box.maxZ() >= secPos.maxBlockZ() ? 15 : SectionPos.sectionRelative((int)box.maxZ());
                    for (int y = secMinY; y <= secMaxY; ++y) {
                        for (int z = secMinZ; z <= secMaxZ; ++z) {
                            for (int x = secMinX; x <= secMaxX; ++x) {
                                BlockPos pos = secPos.origin().offset(x, y, z);
                                BlockState state = section.getBlockState(x, y, z);
                                action.accept(pos, state);
                            }
                        }
                    }
                }
            }
        }
    }
}

