/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.apiimpl.music;

import java.time.LocalDate;
import java.time.Month;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicCapabilities;
import pokefenn.totemic.api.music.MusicAPI;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModSounds;
import pokefenn.totemic.util.BlockUtil;
import pokefenn.totemic.util.MiscUtil;

public enum MusicApiImpl implements MusicAPI
{
    INSTANCE;

    public static final boolean isChristmasTime;
    private static final int[] silentNightBars;
    private static volatile int silentNightCounter;

    @Override
    public void playMusic(Level level, Vec3 pos, @Nullable Entity entity, MusicInstrument instr) {
        this.playMusic(level, pos, entity, instr, 5, instr.getBaseOutput());
    }

    @Override
    public void playMusic(Entity entity, MusicInstrument instr) {
        this.playMusic(entity.level(), entity.position(), entity, instr, 5, instr.getBaseOutput());
    }

    @Override
    public void playMusic(Level level, BlockPos pos, @Nullable Entity entity, MusicInstrument instr) {
        this.playMusic(level, Vec3.atCenterOf((Vec3i)pos), entity, instr);
    }

    @Override
    public void playMusic(Level level, Vec3 pos, @Nullable Entity entity, MusicInstrument instr, int range, int amount) {
        MusicApiImpl.playInstrumentSound(level, pos, entity, instr);
        if (level.isClientSide) {
            return;
        }
        level.getProfiler().push("totemic.playMusic");
        MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.NOTE, level, pos, 6, new Vec3(0.5, 0.5, 0.5), 0.0);
        List<MusicAcceptor> list = BlockUtil.getBlockEntitiesInRange(null, level, BlockPos.containing((Position)pos), range).map(tile -> (MusicAcceptor)level.getCapability(TotemicCapabilities.MUSIC_ACCEPTOR, tile.getBlockPos(), tile.getBlockState(), tile)).filter(acc -> acc != null && acc.canAcceptMusic(instr)).collect(MiscUtil.collectMaxElements(Comparator.comparing(MusicAcceptor::getPriority)));
        for (MusicAcceptor acc2 : list) {
            MusicAcceptor.MusicResult result = acc2.acceptMusic(instr, amount / list.size(), pos, entity);
            if (result.isSuccess()) {
                MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.NOTE, level, acc2.getPosition(), 6, new Vec3(0.5, 0.5, 0.5), 0.0);
            }
            if (!result.isSaturated()) continue;
            MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.CLOUD, level, acc2.getPosition(), 6, new Vec3(0.5, 0.5, 0.5), 0.0);
        }
        level.getProfiler().pop();
    }

    @Override
    public void playSelector(Level level, Vec3 pos, Entity entity, MusicInstrument instr) {
        this.playSelector(level, pos, entity, instr, 5);
    }

    @Override
    public void playSelector(Entity entity, MusicInstrument instr) {
        this.playSelector(entity.level(), entity.position(), entity, instr, 5);
    }

    @Override
    public void playSelector(Level level, BlockPos pos, Entity entity, MusicInstrument instr) {
        this.playSelector(level, Vec3.atCenterOf((Vec3i)pos), entity, instr);
    }

    @Override
    public void playSelector(Level level, Vec3 pos, Entity entity, MusicInstrument instr, int range) {
        MusicApiImpl.playInstrumentSound(level, pos, entity, instr);
        if (level.isClientSide) {
            return;
        }
        level.getProfiler().push("totemic.playSelector");
        MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.NOTE, level, pos, 6, new Vec3(0.5, 0.5, 0.5), 0.0);
        MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.FIREWORK, level, pos, 2, new Vec3(0.5, 0.5, 0.5), 0.0);
        BlockUtil.getBlockEntitiesInRange(ModBlockEntities.totem_base.get(), level, BlockPos.containing((Position)pos), range).map(TotemBaseBlockEntity::getTotemState).filter(TotemState::canSelect).max(Comparator.comparing(MusicAcceptor::getPriority).thenComparingDouble(acc -> -acc.getPosition().distanceToSqr(pos))).ifPresent(t -> t.addSelector(entity, instr));
        level.getProfiler().pop();
    }

    private static void playInstrumentSound(Level level, Vec3 pos, @Nullable Entity entity, MusicInstrument instr) {
        if (instr.getSound() != null) {
            SoundSource source = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.BLOCKS;
            SoundEvent sound = instr.getSound().get();
            if (isChristmasTime && instr == ModContent.flute.get()) {
                sound = ModSounds.silentnight[silentNightBars[silentNightCounter]].get();
                if (level.getServer() == null || level.getServer().isDedicatedServer()) {
                    silentNightCounter = (silentNightCounter + 1) % silentNightBars.length;
                }
            }
            level.playSound(entity instanceof Player ? (Player)entity : null, pos.x, pos.y, pos.z, sound, source, 1.0f, 1.0f);
        }
    }

    static {
        silentNightBars = new int[]{0, 0, 1, 2, 3, 0, 3, 0, 4, 5, 6, 7};
        silentNightCounter = 0;
        LocalDate today = LocalDate.now();
        boolean bl = isChristmasTime = today.getMonth() == Month.DECEMBER && today.getDayOfMonth() >= 24 && today.getDayOfMonth() <= 29;
        if (isChristmasTime) {
            Totemic.logger.info("Merry Christmas!");
        }
    }
}

