/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.music;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.util.BlockUtil;

public class DrumBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty PLAYED = BooleanProperty.create((String)"played");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);

    public DrumBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PLAYED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        this.playMusic(state, level, pos, player);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        this.playMusic(state, level, pos, player);
    }

    private void playMusic(BlockState state, Level level, BlockPos pos, Player player) {
        if (!((Boolean)state.getValue((Property)PLAYED)).booleanValue()) {
            if (!player.isShiftKeyDown()) {
                this.putOnCooldown(state, level, pos);
                TotemicAPI.get().music().playMusic(level, pos, (Entity)player, ModContent.drum.get());
            } else {
                this.putOnCooldown(state, level, pos);
                TotemicAPI.get().music().playSelector(level, pos, (Entity)player, ModContent.drum.get());
            }
        }
    }

    private void putOnCooldown(BlockState state, Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)PLAYED, (Comparable)Boolean.valueOf(true)), 3);
        level.scheduleTick(pos, (Block)this, 20);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        level.setBlock(pos, (BlockState)state.setValue((Property)PLAYED, (Comparable)Boolean.valueOf(false)), 3);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PLAYED, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(BlockUtil.placedInWater(context)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.empty();
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        BlockUtil.scheduleWaterloggedTick(pState, pCurrentPos, pLevel);
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

