/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.music.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.util.BlockUtil;

public class WindChimeBlockEntity
extends BlockEntity {
    public static final int CONGESTION_RANGE = 8;
    public static final int MAX_NEARBY_CHIMES = 2;
    private int playingTimeLeft = 0;
    private int cooldown = 0;
    private boolean isCongested = false;
    private static final int PLAYING_TIME = 160;

    public WindChimeBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.wind_chime.get(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WindChimeBlockEntity tile) {
        if (tile.isPlaying()) {
            if (tile.playingTimeLeft % 40 == 0) {
                tile.playMusic(level, pos, state);
            }
            --tile.playingTimeLeft;
            if (tile.playingTimeLeft <= 0) {
                tile.setNotPlaying();
            }
        } else {
            if (!tile.isCongested && !level.isClientSide) {
                --tile.cooldown;
                if (tile.cooldown <= 0) {
                    tile.setPlaying(160);
                }
            }
            if (tile.isCongested && level.isClientSide) {
                tile.congestionParticles();
            }
        }
    }

    private void playMusic(Level level, BlockPos pos, BlockState state) {
        BlockState above = level.getBlockState(pos.above());
        int baseAmount = ModContent.wind_chime.get().getBaseOutput();
        int bonus = above.is(BlockTags.LEAVES) ? baseAmount / 2 : 0;
        TotemicAPI.get().music().playMusic(level, Vec3.atBottomCenterOf((Vec3i)pos), null, ModContent.wind_chime.get(), 5, baseAmount + bonus);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.isCongested = this.checkForCongestion();
        }
    }

    public boolean isPlaying() {
        return this.playingTimeLeft > 0 && !this.isCongested;
    }

    public void setPlaying(int time) {
        this.playingTimeLeft = time;
        if (!this.level.isClientSide) {
            this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, time);
        }
        this.setChanged();
    }

    public void setNotPlaying() {
        this.playingTimeLeft = 0;
        if (!this.level.isClientSide) {
            this.cooldown = this.getRandomCooldown(this.level.random);
        }
        this.setChanged();
    }

    public boolean triggerEvent(int id, int param) {
        if (!this.level.isClientSide) {
            return true;
        }
        this.setPlaying(param);
        return true;
    }

    private int getRandomCooldown(RandomSource rand) {
        return (int)(20.0 * (40.0 + 5.0 * rand.nextGaussian()));
    }

    private boolean checkForCongestion() {
        long count = BlockUtil.getBlockEntitiesInRange(ModBlockEntities.wind_chime.get(), this.level, this.worldPosition, 8).filter(tile -> tile != this && !tile.isCongested).limit(3L).count();
        return count > 2L;
    }

    public void tryUncongest() {
        if (this.isCongested) {
            this.isCongested = this.checkForCongestion();
            if (!this.isCongested) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            }
        }
    }

    private void congestionParticles() {
        if (this.level.getGameTime() % 2L == 0L) {
            RandomSource rand = this.level.getRandom();
            BlockPos pos = this.getBlockPos();
            this.level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CRIT, (double)((float)pos.getX() + rand.nextFloat()), (double)((float)pos.getY() + rand.nextFloat()), (double)((float)pos.getZ() + rand.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.isPlaying()) {
            tag.putInt("PlayingTime", this.playingTimeLeft);
        } else {
            tag.putInt("Cooldown", this.cooldown);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("PlayingTime")) {
            this.playingTimeLeft = tag.getInt("PlayingTime");
        } else {
            this.playingTimeLeft = 0;
            this.cooldown = tag.getInt("Cooldown");
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("PlayingTime", this.playingTimeLeft);
        tag.putBoolean("IsCongested", this.isCongested);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.playingTimeLeft = tag.getInt("PlayingTime");
        this.isCongested = tag.getBoolean("IsCongested");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
    }
}

