/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem;

import com.mojang.serialization.MapCodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.block.totem.entity.StateCeremonyEffect;
import pokefenn.totemic.block.totem.entity.StateSelection;
import pokefenn.totemic.block.totem.entity.StateStartup;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModDataComponents;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.item.TotemPoleItem;
import pokefenn.totemic.util.BlockUtil;

public class TotemBaseBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<TotemBaseBlock> CODEC = TotemBaseBlock.simpleCodec(TotemBaseBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.5, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)4.5, (double)2.0, (double)14.0, (double)16.0, (double)14.0));

    public TotemBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(ModItems.totemic_staff)) {
            return this.onTotemicStaffRightClick(level, pos, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private ItemInteractionResult onTotemicStaffRightClick(Level level, BlockPos pos, Player player) {
        if (!level.isClientSide) {
            return ItemInteractionResult.CONSUME;
        }
        level.getBlockEntity(pos, ModBlockEntities.totem_base.get()).ifPresent(tile -> {
            TotemState totemState = tile.getTotemState();
            Objects.requireNonNull(totemState);
            TotemState selector0$temp = totemState;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StateTotemEffect.class, StateSelection.class, StateStartup.class, StateCeremonyEffect.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    StateTotemEffect state = (StateTotemEffect)selector0$temp;
                    player.displayClientMessage((Component)Component.translatable((String)"totemic.isDoingNoCeremony"), false);
                    if (!Minecraft.getInstance().options.advancedItemTooltips) break;
                    player.displayClientMessage((Component)Component.translatable((String)"totemic.totemEffectMusic", (Object[])new Object[]{state.getTotemEffectMusic(), 7680}).withStyle(ChatFormatting.GRAY), false);
                    break;
                }
                case 1: {
                    StateSelection state = (StateSelection)selector0$temp;
                    String selectors = state.getSelectors().stream().map(instr -> instr.getDisplayName().getString()).collect(Collectors.joining(", "));
                    player.displayClientMessage((Component)Component.translatable((String)"totemic.isDoingSelection", (Object[])new Object[]{selectors}), false);
                    break;
                }
                case 2: {
                    StateStartup state = (StateStartup)selector0$temp;
                    player.displayClientMessage((Component)Component.translatable((String)"totemic.isDoingStartup", (Object[])new Object[]{state.getCeremony().getDisplayName()}), false);
                    break;
                }
                case 3: {
                    StateCeremonyEffect state = (StateCeremonyEffect)selector0$temp;
                    player.displayClientMessage((Component)Component.translatable((String)"totemic.isDoingCeremony", (Object[])new Object[]{state.getCeremony().getDisplayName()}), false);
                }
            }
        });
        return ItemInteractionResult.SUCCESS;
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.getMainHandItem().getItem() == ModItems.totemic_staff.get()) {
            level.getBlockEntity(pos, ModBlockEntities.totem_base.get()).ifPresent(TotemBaseBlockEntity::resetTotemState);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP) {
            level.getBlockEntity(currentPos, ModBlockEntities.totem_base.get()).ifPresent(TotemBaseBlockEntity::onPoleChange);
        }
        BlockUtil.scheduleWaterloggedTick(state, currentPos, level);
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.getBlockEntity(pos, ModBlockEntities.totem_base.get()).ifPresent(pole -> pole.setWoodType(TotemPoleItem.getWoodType(stack)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(BlockUtil.placedInWater(context)));
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return level.getBlockEntity(pos, ModBlockEntities.totem_base.get()).map(base -> base.getTotemState().getAnalogOutputSignal()).orElse(0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TotemBaseBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockUtil.createTickerHelper(type, ModBlockEntities.totem_base.get(), TotemBaseBlockEntity::tick);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return level.getBlockEntity(pos, ModBlockEntities.totem_base.get()).map(base -> base.getWoodType().woodColor()).orElse(defaultColor);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        Optional tile = pLevel.getBlockEntity(pPos, ModBlockEntities.totem_base.get());
        TotemWoodType woodType = tile.map(TotemBaseBlockEntity::getWoodType).orElseGet((Supplier<TotemWoodType>)ModContent.oak);
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(ModDataComponents.WOOD_TYPE, (Object)woodType);
        return stack;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

