/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemPoleBlockEntity;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModDataComponents;
import pokefenn.totemic.item.TotemPoleItem;
import pokefenn.totemic.util.BlockUtil;

public class TotemPoleBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<TotemPoleBlock> CODEC = TotemPoleBlock.simpleCodec(TotemPoleBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public TotemPoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP) {
            this.findTotemBase((BlockGetter)level, currentPos).ifPresent(TotemBaseBlockEntity::onPoleChange);
        }
        BlockUtil.scheduleWaterloggedTick(state, currentPos, level);
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TotemWoodType woodType = TotemPoleItem.getWoodType(stack);
        TotemCarving carving = TotemPoleItem.getCarving(stack);
        level.getBlockEntity(pos, ModBlockEntities.totem_pole.get()).ifPresent(pole -> pole.setAppearance(woodType, carving));
        this.findTotemBase((BlockGetter)level, pos).ifPresent(TotemBaseBlockEntity::onPoleChange);
    }

    private Optional<TotemBaseBlockEntity> findTotemBase(BlockGetter level, BlockPos currentPos) {
        for (int i = 0; i < 5; ++i) {
            BlockPos searchPos = currentPos.below(i + 1);
            BlockEntity blockEntity = level.getBlockEntity(searchPos);
            if (blockEntity instanceof TotemBaseBlockEntity) {
                TotemBaseBlockEntity base = (TotemBaseBlockEntity)blockEntity;
                return Optional.of(base);
            }
            if (!(blockEntity instanceof TotemPoleBlockEntity)) break;
        }
        return Optional.empty();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(BlockUtil.placedInWater(context)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TotemPoleBlockEntity(pPos, pState);
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return level.getBlockEntity(pos, ModBlockEntities.totem_pole.get()).map(pole -> pole.getWoodType().woodColor()).orElse(defaultColor);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        Optional tile = pLevel.getBlockEntity(pPos, ModBlockEntities.totem_pole.get());
        TotemWoodType woodType = tile.map(TotemPoleBlockEntity::getWoodType).orElseGet((Supplier<TotemWoodType>)ModContent.oak);
        TotemCarving carving = tile.map(TotemPoleBlockEntity::getCarving).orElseGet((Supplier<TotemCarving>)ModContent.none);
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(ModDataComponents.WOOD_TYPE, (Object)woodType);
        stack.set(ModDataComponents.CARVING, (Object)carving);
        return stack;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

