/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.StateStartup;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.client.CeremonyHUD;
import pokefenn.totemic.util.MiscUtil;

public final class StateSelection
extends TotemState {
    static final byte ID = 1;
    private StateTotemEffect previousState;
    private final List<MusicInstrument> selectors = new ArrayList<MusicInstrument>(2);
    private int time = 0;
    private static Map<List<MusicInstrument>, Ceremony> selectorsToCeremonyMap;

    StateSelection(TotemBaseBlockEntity tile, StateTotemEffect previousState) {
        super(tile);
        this.previousState = previousState;
    }

    StateSelection(TotemBaseBlockEntity tile) {
        this(tile, new StateTotemEffect(tile));
    }

    @Override
    public boolean canSelect() {
        return true;
    }

    @Override
    public void addSelector(Entity entity, MusicInstrument instr) {
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.NOTE, this.tile.getLevel(), this.getPosition(), 6, new Vec3(0.5, 0.5, 0.5), 0.0);
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.FIREWORK, this.tile.getLevel(), this.getPosition(), 16, new Vec3(0.6, 0.5, 0.6), 0.0);
        this.selectors.add(instr);
        this.time = 0;
        this.tile.setChanged();
        if (this.selectors.size() >= 2) {
            Ceremony match = StateSelection.getCeremony(this.selectors);
            if (match != null && !StateSelection.isDisabled(match, entity)) {
                CeremonyInstance instance = match.createInstance();
                if (instance.canSelect(this.tile.getLevel(), this.tile.getBlockPos(), entity)) {
                    this.tile.setTotemState(new StateStartup(this.tile, match, instance, entity));
                } else {
                    this.resetTotemState();
                }
            } else if (this.selectors.size() >= 2) {
                this.resetTotemState();
            }
        }
    }

    private static boolean isDisabled(Ceremony ceremony, Entity entity) {
        if (((List)TotemicConfig.SERVER.disabledCeremonies.get()).contains(ceremony.getRegistryName().toString())) {
            entity.sendSystemMessage((Component)Component.translatable((String)"totemic.ceremonyDisabled", (Object[])new Object[]{ceremony.getDisplayName()}));
            return true;
        }
        return false;
    }

    @Override
    public boolean canAcceptMusic(MusicInstrument instr) {
        return false;
    }

    @Override
    public MusicAcceptor.MusicResult acceptMusic(MusicInstrument instr, int amount, Vec3 from, @Nullable Entity entity) {
        return MusicAcceptor.MusicResult.FAILURE;
    }

    @Override
    public int getPriority() {
        return 16;
    }

    @Override
    public void tick() {
        if (!this.tile.getLevel().isClientSide) {
            if (this.time++ >= 1200) {
                this.tile.setTotemState(this.previousState);
            }
        } else {
            CeremonyHUD.INSTANCE.setActiveTotem(this.tile);
        }
    }

    public List<MusicInstrument> getSelectors() {
        return this.selectors;
    }

    @Nullable
    private static Ceremony getCeremony(List<MusicInstrument> selectors) {
        if (selectorsToCeremonyMap == null) {
            selectorsToCeremonyMap = TotemicAPI.get().registry().ceremonies().stream().collect(Collectors.toUnmodifiableMap(Ceremony::getSelectors, Function.identity()));
        }
        return selectorsToCeremonyMap.get(selectors);
    }

    @Override
    void resetTotemState() {
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.tile.getLevel(), this.getPosition(), 16, new Vec3(0.6, 0.5, 0.6), 0.0);
        this.tile.setTotemState(this.previousState);
    }

    @Override
    byte getID() {
        return 1;
    }

    @Override
    void save(CompoundTag tag, HolderLookup.Provider regsitries) {
        ListTag selectorsTag = new ListTag();
        for (MusicInstrument instr : this.selectors) {
            selectorsTag.add((Object)StringTag.valueOf((String)instr.getRegistryName().toString()));
        }
        tag.put("Selectors", (Tag)selectorsTag);
        tag.putInt("Time", this.time);
        this.previousState.save(tag, regsitries);
    }

    @Override
    void load(CompoundTag tag, HolderLookup.Provider regsitries) {
        this.selectors.clear();
        ListTag selectorsTag = tag.getList("Selectors", 8);
        for (int i = 0; i < selectorsTag.size(); ++i) {
            String name = selectorsTag.getString(i);
            MusicInstrument instr = (MusicInstrument)TotemicAPI.get().registry().instruments().get(ResourceLocation.tryParse((String)name));
            if (instr != null) {
                this.selectors.add(instr);
                continue;
            }
            Totemic.logger.error("Unknown music instrument: '{}'", (Object)name);
        }
        this.time = tag.getInt("Time");
        this.previousState.load(tag, regsitries);
    }
}

