/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.client.model.totem.TotemPoleModelData;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;

public class TotemPoleBlockEntity
extends BlockEntity {
    private ResourceLocation woodTypeLoc = ModContent.oak.getId();
    private ResourceLocation carvingLoc = ModContent.none.getId();
    private volatile TotemWoodType woodType = (TotemWoodType)ModContent.oak.get();
    private volatile TotemCarving carving = (TotemCarving)ModContent.none.get();

    public TotemPoleBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.totem_pole.get(), pPos, pBlockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("Wood", this.woodTypeLoc.toString());
        tag.putString("Carving", this.carvingLoc.toString());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.woodTypeLoc = Objects.requireNonNullElse(ResourceLocation.tryParse((String)tag.getString("Wood")), ModContent.oak.getId());
        Optional optWood = TotemicAPI.get().registry().woodTypes().getOptional(this.woodTypeLoc);
        if (optWood.isEmpty()) {
            Totemic.logger.warn("Unknown Totem Wood Type: '{}'", (Object)this.woodTypeLoc);
        }
        this.woodType = (TotemWoodType)optWood.orElseGet(ModContent.oak);
        this.carvingLoc = Objects.requireNonNullElse(ResourceLocation.tryParse((String)tag.getString("Carving")), ModContent.none.getId());
        Optional optCarving = TotemicAPI.get().registry().totemCarvings().getOptional(this.carvingLoc);
        if (optCarving.isEmpty()) {
            Totemic.logger.warn("Unknown Totem Carving: '{}'", (Object)this.carvingLoc);
        }
        this.carving = (TotemCarving)optCarving.orElseGet(ModContent.none);
        this.requestModelDataUpdate();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public TotemWoodType getWoodType() {
        return this.woodType;
    }

    public TotemCarving getCarving() {
        return this.carving;
    }

    public void setAppearance(TotemWoodType woodType, TotemCarving carving) {
        this.woodType = Objects.requireNonNull(woodType);
        this.woodTypeLoc = woodType.getRegistryName();
        this.carving = Objects.requireNonNull(carving);
        this.carvingLoc = carving.getRegistryName();
        this.requestModelDataUpdate();
        this.setChanged();
    }

    public ModelData getModelData() {
        return ModelData.builder().with(TotemPoleModelData.DATA_PROPERTY, (Object)new TotemPoleModelData(this.woodType, this.carving)).build();
    }
}

