/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.init.ModDataMapTypes;
import pokefenn.totemic.util.MiscUtil;

public enum CleansingCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RANGE = 8;

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (level.isClientSide) {
            return;
        }
        AABB aabb = TotemicEntityUtil.getAABBAround(pos, 8.0);
        for (Mob mob2 : level.getEntitiesOfClass(Mob.class, aabb, mob -> this.getConversionTarget((Mob)mob).isPresent() && mob.hasEffect(MobEffects.WEAKNESS))) {
            EntityType<? extends Mob> targetType = this.getConversionTarget(mob2).get();
            if (mob2 instanceof ZombieVillager) {
                ZombieVillager zombieVillager = (ZombieVillager)mob2;
                if (targetType == EntityType.VILLAGER) {
                    UUID uuid = context.getInitiatingPlayer().map(Entity::getUUID).orElse(null);
                    zombieVillager.startConverting(uuid, 1);
                    continue;
                }
            }
            try {
                Mob converted = mob2.convertTo(targetType, true);
                if (converted == null) continue;
                converted.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, level, converted.getBoundingBox().getCenter(), 10, new Vec3(0.6, 0.5, 0.6), 1.0);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Invalid conversion target '" + targetType.builtInRegistryHolder().getRegisteredName() + "' for the cleasing ceremony, must be a Mob entity type", e);
            }
        }
    }

    @Override
    public boolean canSelect(Level level, BlockPos pos, Entity initiator) {
        if (level.getEntitiesOfClass(Mob.class, TotemicEntityUtil.getAABBAround(pos, 8.0), mob -> this.getConversionTarget((Mob)mob).isPresent() && mob.hasEffect(MobEffects.WEAKNESS)).isEmpty()) {
            initiator.sendSystemMessage((Component)Component.translatable((String)"totemic.noZombifiedMonstersNearby"));
            return false;
        }
        return true;
    }

    private Optional<EntityType<? extends Mob>> getConversionTarget(Mob mob) {
        return Optional.ofNullable((EntityType)mob.getType().builtInRegistryHolder().getData(ModDataMapTypes.CLEANSING_CEREMONY_CONVERSIONS));
    }
}

