/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import pokefenn.totemic.entity.Buffalo;

public class BuffaloModel<T extends Buffalo>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;

    public BuffaloModel(ModelPart root) {
        super(true, 10.0f, 2.0f);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.tail = root.getChild("tail");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 45).addBox(-4.5f, -7.0f, -7.0f, 9.0f, 7.0f, 9.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-7.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("hornbase1", CubeListBuilder.create().texOffs(52, 0).addBox(-7.5f, -4.0f, -1.0f, 4.0f, 2.0f, 2.0f, true), PartPose.ZERO);
        head.addOrReplaceChild("hornbase2", CubeListBuilder.create().texOffs(52, 0).addBox(3.5f, -4.0f, -1.0f, 4.0f, 2.0f, 2.0f, false), PartPose.ZERO);
        head.addOrReplaceChild("horn1", CubeListBuilder.create().texOffs(52, 4).addBox(6.5f, -4.0f, 0.0f, 2.0f, 2.0f, 4.0f, false), PartPose.ZERO);
        head.addOrReplaceChild("horn2", CubeListBuilder.create().texOffs(52, 10).addBox(5.5f, -4.0f, 2.0f, 2.0f, 2.0f, 3.0f, false), PartPose.ZERO);
        head.addOrReplaceChild("horn3", CubeListBuilder.create().texOffs(52, 15).addBox(5.5f, -4.0f, 5.0f, 1.0f, 1.0f, 1.0f, false), PartPose.ZERO);
        head.addOrReplaceChild("horn4", CubeListBuilder.create().texOffs(52, 4).addBox(-8.5f, -4.0f, 0.0f, 2.0f, 2.0f, 4.0f, true), PartPose.ZERO);
        head.addOrReplaceChild("horn5", CubeListBuilder.create().texOffs(52, 10).addBox(-7.5f, -4.0f, 2.0f, 2.0f, 2.0f, 3.0f, true), PartPose.ZERO);
        head.addOrReplaceChild("horn6", CubeListBuilder.create().texOffs(52, 15).addBox(-6.5f, -4.0f, 5.0f, 1.0f, 1.0f, 1.0f, true), PartPose.ZERO);
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -10.0f, -9.0f, 12.0f, 10.0f, 13.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)2.0f, (float)1.4835298f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 23).addBox(-5.5f, 0.0f, -8.5f, 11.0f, 10.0f, 12.0f, true), PartPose.ZERO);
        body.addOrReplaceChild("udder", CubeListBuilder.create().texOffs(28, 46).addBox(-3.5f, 4.0f, -9.5f, 7.0f, 5.0f, 1.0f, true), PartPose.ZERO);
        PartDefinition tail = root.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(28, 53).addBox(-1.0f, 0.0f, -9.5f, 2.0f, 1.0f, 8.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)11.5f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("tailhairs", CubeListBuilder.create().texOffs(35, 62).addBox(-1.0f, 0.0f, -10.5f, 2.0f, 1.0f, 1.0f, true), PartPose.ZERO);
        PartDefinition leg1 = root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(46, 18).addBox(-1.0f, 0.0f, -3.0f, 4.0f, 11.0f, 5.0f, false), PartPose.offsetAndRotation((float)4.0f, (float)10.0f, (float)-5.0f, (float)0.13962634f, (float)0.0f, (float)0.0f));
        leg1.addOrReplaceChild("hoof1", CubeListBuilder.create().texOffs(46, 34).addBox(-0.5f, 8.0f, 0.0f, 3.0f, 6.0f, 3.0f, false), PartPose.rotation((float)-0.13962634f, (float)0.0f, (float)0.0f));
        PartDefinition leg2 = root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(46, 18).addBox(-3.0f, 0.0f, -3.0f, 4.0f, 11.0f, 5.0f, true), PartPose.offsetAndRotation((float)-4.0f, (float)10.0f, (float)-5.0f, (float)0.13962634f, (float)0.0f, (float)0.0f));
        leg2.addOrReplaceChild("hoof2", CubeListBuilder.create().texOffs(46, 34).addBox(-2.5f, 8.0f, 0.0f, 3.0f, 6.0f, 3.0f, true), PartPose.rotation((float)-0.13962634f, (float)0.0f, (float)0.0f));
        PartDefinition leg3 = root.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(48, 43).addBox(-1.0f, 0.0f, -3.0f, 4.0f, 8.0f, 4.0f, false), PartPose.offset((float)4.0f, (float)10.0f, (float)10.0f));
        leg3.addOrReplaceChild("hoof3", CubeListBuilder.create().texOffs(48, 55).addBox(-0.5f, 8.0f, -2.0f, 3.0f, 6.0f, 3.0f, false), PartPose.ZERO);
        PartDefinition leg4 = root.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(48, 43).addBox(-3.0f, 0.0f, -3.0f, 4.0f, 8.0f, 4.0f, true), PartPose.offset((float)-4.0f, (float)10.0f, (float)10.0f));
        leg4.addOrReplaceChild("hoof4", CubeListBuilder.create().texOffs(48, 55).addBox(-2.5f, 8.0f, -2.0f, 3.0f, 6.0f, 3.0f, true), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return List.of(this.body, this.tail, this.leg1, this.leg2, this.leg3, this.leg4);
    }

    public void setupAnim(T buffalo, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legSpeed = 0.6662f;
        float legFactor = 1.4f;
        this.head.xRot = headPitch * ((float)Math.PI / 180) + 1.5707964f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + 0.13962634f;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + 0.13962634f;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public void renderToBuffer(PoseStack ps, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        ps.pushPose();
        ps.translate(0.0f, -0.75f, 0.0f);
        ps.scale(1.5f, 1.5f, 1.5f);
        super.renderToBuffer(ps, buffer, packedLight, packedOverlay, color);
        ps.popPose();
    }
}

