/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.client.CeremonyHUD;
import pokefenn.totemic.client.model.totem.TotemBaseModel;
import pokefenn.totemic.client.model.totem.TotemPoleModel;
import pokefenn.totemic.init.ModBlocks;

public class ClientInitHandlers {
    private static final ModelResourceLocation OPAQUE_CEDAR_LEAVES = ModelResourceLocation.standalone((ResourceLocation)Totemic.resloc("block/cedar_leaves_opaque"));

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, tintGetter, pos, tintIndex) -> tintIndex, new Block[]{(Block)ModBlocks.totem_pole.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex, new ItemLike[]{(ItemLike)ModBlocks.totem_pole.get()});
    }

    @SubscribeEvent
    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(Totemic.resloc("totem_pole"), (IGeometryLoader)TotemPoleModel.Loader.INSTANCE);
        event.register(Totemic.resloc("totem_base"), (IGeometryLoader)TotemBaseModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        if (!Minecraft.useFancyGraphics()) {
            event.register(OPAQUE_CEDAR_LEAVES);
        }
    }

    @SubscribeEvent
    public static void onBakingComplete(ModelEvent.ModifyBakingResult event) {
        BakedModel opaqueLeaves;
        if (!Minecraft.useFancyGraphics() && (opaqueLeaves = (BakedModel)event.getModels().get(OPAQUE_CEDAR_LEAVES)) != null) {
            for (BlockState state : ((LeavesBlock)ModBlocks.cedar_leaves.get()).getStateDefinition().getPossibleStates()) {
                event.getModels().put(BlockModelShaper.stateToModelLocation((BlockState)state), opaqueLeaves);
            }
        }
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, Totemic.resloc("ceremony_hud"), (LayeredDraw.Layer)CeremonyHUD.INSTANCE);
    }
}

