/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import pokefenn.totemic.item.MedicineBagItem;

public class CreativeMedicineBagItem
extends MedicineBagItem {
    public CreativeMedicineBagItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        level.getProfiler().push("totemic.medicineBag");
        int creativeChargeValue = -1;
        if (CreativeMedicineBagItem.isOpen(stack)) {
            CreativeMedicineBagItem.getEffects(stack).forEach(effect -> {
                int interval = effect.getInterval();
                if (level.getGameTime() % (long)interval == 0L) {
                    effect.medicineBagEffect((Player)entity, stack, -1);
                }
            });
        }
        level.getProfiler().pop();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        String key = CreativeMedicineBagItem.getCarving(stack).isPresent() ? (CreativeMedicineBagItem.isOpen(stack) ? "open" : "closed") : "tooltip";
        tooltip.add((Component)Component.translatable((String)("totemic.medicineBag." + key)));
    }

    @Override
    public boolean isBarVisible(ItemStack pStack) {
        return false;
    }
}

