/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.totem.MedicineBagEffect;
import pokefenn.totemic.api.totem.PortableTotemCarving;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemPoleBlockEntity;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModDataComponents;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.util.BlockUtil;
import pokefenn.totemic.util.MiscUtil;

public class MedicineBagItem
extends Item {
    public static final int MAX_CHARGE = 4800;

    public MedicineBagItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void registerItemProperties() {
        ItemPropertyFunction func = (stack, level, entity, seed) -> MedicineBagItem.isOpen(stack) ? 1.0f : 0.0f;
        ResourceLocation name = Totemic.resloc("open");
        ItemProperties.register((Item)((Item)ModItems.medicine_bag.get()), (ResourceLocation)name, (ItemPropertyFunction)func);
        ItemProperties.register((Item)((Item)ModItems.creative_medicine_bag.get()), (ResourceLocation)name, (ItemPropertyFunction)func);
    }

    public static Optional<PortableTotemCarving> getCarving(ItemStack stack) {
        return MiscUtil.filterAndCast(Optional.ofNullable((TotemCarving)stack.get(ModDataComponents.CARVING)).filter(carving -> carving != ModContent.none.get()), PortableTotemCarving.class);
    }

    public static List<MedicineBagEffect> getEffects(ItemStack stack) {
        return MedicineBagItem.getCarving(stack).map(PortableTotemCarving::getMedicineBagEffects).orElse(List.of());
    }

    public static int getCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.MEDICINE_BAG_CHARGE, (Object)0);
    }

    public static boolean isOpen(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.OPEN, (Object)false);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        int charge;
        level.getProfiler().push("totemic.medicineBag");
        if (!level.isClientSide && level.getGameTime() % 20L == 0L) {
            this.tryCharge(stack, level, entity.blockPosition());
        }
        if (MedicineBagItem.isOpen(stack) && (charge = MedicineBagItem.getCharge(stack)) > 0) {
            MedicineBagItem.getEffects(stack).forEach(effect -> {
                int interval = effect.getInterval();
                if (level.getGameTime() % (long)interval == 0L) {
                    effect.medicineBagEffect((Player)entity, stack, charge);
                    stack.set(ModDataComponents.MEDICINE_BAG_CHARGE, (Object)Math.max(charge - interval, 0));
                }
            });
        }
        level.getProfiler().pop();
    }

    private void tryCharge(ItemStack stack, Level level, BlockPos pos) {
        int charge = MedicineBagItem.getCharge(stack);
        if (charge < 4800) {
            MedicineBagItem.getCarving(stack).ifPresent(carving -> {
                if (BlockUtil.getBlockEntitiesInRange(ModBlockEntities.totem_base.get(), level, pos, 6).anyMatch(tile -> tile.getTotemState() instanceof StateTotemEffect && tile.hasCarving((TotemCarving)carving))) {
                    stack.set(ModDataComponents.MEDICINE_BAG_CHARGE, (Object)Math.min(charge + 400, 4800));
                }
            });
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        return this.toggleOpen(pPlayer.getItemInHand(pUsedHand));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        if (!ctx.isSecondaryUseActive()) {
            InteractionResultHolder<ItemStack> result = this.toggleOpen(stack);
            return result.getResult();
        }
        return this.trySetCarving(stack, ctx.getPlayer(), ctx.getLevel(), ctx.getClickedPos(), ctx.getHand());
    }

    private InteractionResultHolder<ItemStack> toggleOpen(ItemStack stack) {
        if (MedicineBagItem.getCarving(stack).isPresent()) {
            stack.update(ModDataComponents.OPEN, (Object)false, open -> open == false);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private InteractionResult trySetCarving(ItemStack stack, Player player, Level level, BlockPos pos, InteractionHand hand) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity pole = (TotemPoleBlockEntity)blockEntity;
            TotemCarving carving = pole.getCarving();
            if (carving instanceof PortableTotemCarving) {
                ItemStack newStack = stack.copy();
                newStack.set(ModDataComponents.CARVING, (Object)carving);
                if (!newStack.is((Item)ModItems.creative_medicine_bag.get())) {
                    newStack.set(ModDataComponents.MEDICINE_BAG_CHARGE, (Object)0);
                }
                player.setItemInHand(hand, newStack);
                return InteractionResult.SUCCESS;
            }
            if (level.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"totemic.medicineBag.notPortable", (Object[])new Object[]{carving.getDisplayName()}), true);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{MedicineBagItem.getCarving(stack).orElseGet((Supplier<PortableTotemCarving>)ModContent.none).getDisplayName()});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        String key = MedicineBagItem.getCarving(stack).isPresent() ? (MedicineBagItem.getCharge(stack) > 0 ? (MedicineBagItem.isOpen(stack) ? "open" : "closed") : "empty") : "tooltip";
        tooltip.add((Component)Component.translatable((String)("totemic.medicineBag." + key)));
        if (flag.isAdvanced()) {
            tooltip.add((Component)Component.translatable((String)"totemic.medicineBag.charge", (Object[])new Object[]{MedicineBagItem.getCharge(stack), 4800}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isBarVisible(ItemStack pStack) {
        return true;
    }

    public int getBarWidth(ItemStack pStack) {
        return Math.round(13.0f * (float)MedicineBagItem.getCharge(pStack) / 4800.0f);
    }

    public int getBarColor(ItemStack pStack) {
        float f = (float)MedicineBagItem.getCharge(pStack) / 4800.0f;
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

